#!/usr/bin/env python
#
# @package      hubzero-submit-monitors
# @file         Scripts/boinc/uploadFile.py
# @copyright    Copyright (c) 2017-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2017-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  uploadFile.py
#
#  script which uploads instance input file
#
import sys
import os

from submit_api import *

BOINCPROJECTURL    = ""
BOINCAUTHENTICATOR = ""


class UploadBoincFile:
   def __init__(self,
                boincProjectURL,
                boincAuthenticator,
                localJobId,
                instanceId,
                batchId):
      self.boincProjectURL    = boincProjectURL
      self.boincAuthenticator = boincAuthenticator
      self.localJobId         = localJobId
      self.instanceId         = instanceId
      self.batchId            = int(batchId)


   def run(self):
      exitStatus = 0
      fileUploadRequest = UPLOAD_FILES_REQ()
      fileUploadRequest.project       = self.boincProjectURL
      fileUploadRequest.authenticator = self.boincAuthenticator
      fileUploadRequest.batch_id      = self.batchId
      inputTarFile =  '_'.join([self.localJobId,self.instanceId,'input.tar.gz'])
      fileUploadRequest.local_names   = (inputTarFile,)
      fileUploadRequest.boinc_names   = (inputTarFile,)

      fileUploadResponse = upload_files(fileUploadRequest)

      try:
         if fileUploadResponse.find('error') is not None:
            exitStatus = 1
            errMessage = fileUploadResponse.find('error').find('error_msg').text
            sys.stderr.write(errMessage + '\n')
      except:
         exitStatus = 1
         errMessage = fileUploadResponse.text
         sys.stderr.write("%s\n" % (errMessage))

      return(exitStatus)


if __name__ == '__main__':

   if len(sys.argv) == 4:
      localJobId = sys.argv[1]
      instanceId = sys.argv[2]
      batchId    = sys.argv[3]
   else:
      sys.exit(1)

   __uploadBoincFile__ = UploadBoincFile(BOINCPROJECTURL,BOINCAUTHENTICATOR,
                                         localJobId,instanceId,batchId)
   __exitStatus__ = __uploadBoincFile__.run()

   sys.exit(__exitStatus__)


