#
# @package      hubzero-submit-distributor
# @file         Scripts/tapis2/getUserInstanceToken.py
# @copyright    Copyright 2004-2022 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2022 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  getUserInstanceToken.py
#
#  script which queries job database to acquire instanceToken
#
import os
import sys
import logging

from hubzero.submit.DaemonsInfo      import DaemonsInfo
from hubzero.submit.RemoteJobMonitor import RemoteJobMonitor

CONFIGURATIONDIRECTORY   = os.path.join(os.sep,'etc','submit')
DAEMONSCONFIGURATIONFILE = 'daemons.conf'

APPLICATIONLOGGER = logging.getLogger('') 

def openLogger():
   class EmptyFilter(logging.Filter):
      """
      This is a filter which rejects empty messages

      """

      def filter(self,record):
         if record.getMessage() == "":
            emptyRecord = True
         else:
            emptyRecord = False

         return(not emptyRecord)

   APPLICATIONLOGGER.setLevel(logging.DEBUG)

   logHandler = logging.StreamHandler()

   emptyFilter = EmptyFilter()
   logHandler.addFilter(emptyFilter)

   logFormatter = logging.Formatter('%(asctime)s %(message)s','[%a %b %d %H:%M:%S %Y]')
   logHandler.setFormatter(logFormatter)
   APPLICATIONLOGGER.addHandler(logHandler)


def queryJob(listenURI,
             localJobId,
             instanceId):
   """Query Job"""
   hubUserId = os.getuid()

   remoteJobMonitor = RemoteJobMonitor(listenURI)

   instanceToken = remoteJobMonitor.queryInstanceTokenByUserLocalId(hubUserId,
                                                                    localJobId,
                                                                    instanceId)
   
   return instanceToken


if __name__ == '__main__':
   exitStatus = 0
   openLogger()

   localJobId = sys.argv[1]
   instanceId = sys.argv[2]

   configFilePath = os.path.join(CONFIGURATIONDIRECTORY,DAEMONSCONFIGURATIONFILE)
   daemonsInfo    = DaemonsInfo(configFilePath)
   listenURI      = daemonsInfo.getDaemonListenURI('jobMonitor','tcp')

   instanceToken = queryJob(listenURI,localJobId,instanceId)
   if instanceToken:
      print(instanceToken)
   else:
      exitStatus = 1

   sys.exit(exitStatus)


