#!/usr/bin/env python3
#
# @package      hubzero-submit-distributor
# @file         jobKill.py
# @copyright    Copyright (c) 2014-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2014-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
"""Kill batch jobs currently running remotely.
   """
import os
import sys
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.JobKill              import JobKill

JOBKILLLOGLEVEL = "ERROR"

DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'

if __name__ == '__main__':
   jobKillLogLevel          = os.getenv("JOBKILLLOGLEVEL",JOBKILLLOGLEVEL)
   daemonsDirectory         = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)

   applicationUtilities = ApplicationUtilities(JOBKILLLOGLEVEL)

   applicationUtilities.openStreamLogger(sys.stderr,
                                         jobKillLogLevel)

   __jobKill__ = JobKill(daemonsDirectory,daemonsConfigurationFile)

   __exitCode__ = __jobKill__.parseCommandArguments()
   if __exitCode__:
      sys.exit(__exitCode__)

   __exitCode__ = __jobKill__.killActiveJob()

   sys.exit(__exitCode__)


