#!/bin/sh
#
# @package      hubzero-submit-distributor
# @file         Scripts/ll/movepegtmp2home.sh
# @copyright    Copyright 2004-2015 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
if [ $# -ne 2 ] ; then
   echo usage: $0 jobWorkingDirectory jobScratchDirectory
   exit 64
fi

jobWorkingDirectory=$1
jobScratchDirectory=$2

if [ -f ${jobWorkingDirectory}/work/pegasusSetup.sh ] ; then
   . ${jobWorkingDirectory}/work/pegasusSetup.sh
fi

if [ ${jobScratchDirectory} != ${jobWorkingDirectory} ] ; then
   if [ -d ${jobScratchDirectory} ] ; then
      if [ -d ${jobWorkingDirectory} ] ; then
         srcPath=${jobScratchDirectory}/work
         dstPath=${jobWorkingDirectory}/work
         mkdir -p ${srcPath}
         mkdir -p ${dstPath}

         while : ; do
            if [ ! -d ${srcPath} ] ; then
               break
            fi
            if [ ! -d ${dstPath} ] ; then
               break
            fi

            if [ -f ${srcPath}/jobstate.log ] ; then
               cp -p ${srcPath}/jobstate.log ${dstPath}
               jobNames=$(grep JOB_TERMINATED ${dstPath}/jobstate.log 2> /dev/null | grep -v -E ' stage_| create_' | cut -d' ' -f 2)
               if [ -n "${jobNames}" ] ; then
                  for jobName in ${jobNames} ; do
                     cp -n -p ${srcPath}/${jobName}.out.[0-9]* ${dstPath} 2> /dev/null
                  done
               fi
            fi
            pegasus-status --rows ${srcPath} > ${dstPath}/pegasusstatus.txt
            sleep 30
         done
      fi
   fi
else
   if [ -d ${jobWorkingDirectory} ] ; then
      dstPath=${jobWorkingDirectory}/work
      mkdir -p ${dstPath}

      while : ; do
         if [ ! -d ${dstPath} ] ; then
            break
         fi
         pegasus-status --rows ${dstPath} > ${dstPath}/pegasusstatus.txt
         sleep 30
      done
   fi
fi
