#!/bin/sh
#
if [ $# -lt 1 ] ; then
   echo usage: $0 system
   exit 64
fi

system=$1

mkdir --parents --mode 700 .ssh

submitHost=$(hostname -f)

keyFilename=${system}_tapis_rsa
comment=${system}@${submitHost}

ssh-keygen -t rsa -b 4096 -m PEM -N "" -f .ssh/${keyFilename} -C ${comment}

privateKey=$(cat .ssh/${keyFilename} | awk --assign ORS='\\n' '{print}')
publicKey=$(cat .ssh/${keyFilename}.pub | awk --assign ORS='\\n' '{print}')

echo '{'                                  >  ${system}_credential.json
echo '   "userName": "nano1",'            >> ${system}_credential.json
echo '   "publicKey": "'${publicKey}'",'  >> ${system}_credential.json
echo '   "privateKey": "'${privateKey}'"' >> ${system}_credential.json
echo '}'                                  >> ${system}_credential.json
