# @package      hubzero-submit-distributor
# @file         RemoteIdentityManager.py
# @copyright    Copyright (c) 2012-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2012-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
import time
import traceback
import logging

from hubzero.submit.LogMessage        import getLogIDMessage as getLogMessage
from hubzero.submit.MessageConnection import MessageConnection

class RemoteIdentityManager(MessageConnection):
   def __init__(self,
                listenURI):
      MessageConnection.__init__(self,listenURI)

      self.logger = logging.getLogger(__name__)


   def queryUserIdentities(self,
                           identityNames,
                           hubUserName):
      identityPaths = {}
      if isinstance(identityNames,list):
         queryMessage = {'messageType':'getUserIdentities',
                         'identityNames':identityNames,
                         'hubUserName':hubUserName}
      else:
         queryMessage = {'messageType':'getUserIdentities',
                         'identityNames':[identityNames],
                         'hubUserName':hubUserName}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: getUserIdentities(%d):%s" % (nTry,response['messageType'])))

      identityPaths = response['identityPaths']

      return(identityPaths)


   def queryUserHash(self,
                     identityNames,
                     hubUserName,
                     hubUserId):
      identityHash = ""
      identityHashes = []
      if isinstance(identityNames,list):
         queryMessage = {'messageType':'getUserHashes',
                         'identityNames':identityNames,
                         'hubUserName':hubUserName,
                         'hubUserId':hubUserId}
      else:
         queryMessage = {'messageType':'getUserHashes',
                         'identityNames':[identityNames],
                         'hubUserName':hubUserName,
                         'hubUserId':hubUserId}
      nTry,response = self.requestJsonExchange(queryMessage)

      if nTry > 1:
         self.logger.log(logging.WARNING,getLogMessage("confirmation: getUserHash(%d):%s" % (nTry,response['messageType'])))

      identityHashes = response['identityHashes']
      nIdentityHashes = len(identityHashes)
      if   nIdentityHashes == 0:
         self.logger.log(logging.ERROR,getLogMessage("getUserHash(%s): failed" % (hubUserName)))
         identityHash = hubUserName
      elif nIdentityHashes == 1:
         identityHash = identityHashes[0]
      else:
         self.logger.log(logging.ERROR,getLogMessage("getUserHash(%s): multiple hash generated" % (hubUserName)))
         identityHash = identityHashes[0]

      return(identityHash)


