#!/bin/sh
#
# @package      hubzero-submit-monitors
# @file         refresh-condor-proxy.sh
# @copyright    Copyright (c) 2015-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2015-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
scriptPath=$(readlink -f $0)
scriptDir=$(dirname ${scriptPath})

if [ $# -lt 6 -o $# -gt 7 ] ; then
   echo "usage: $0 condorConfig condorQconstraint permanentUsers copy certKeyDirectory communityProxyFile userProxyFile"
   echo "   or: $0 condorConfig condorQconstraint permanentUsers saml gridshibHome userProxyFile"
   exit 64
fi

exitStatus=0

condorConfig=$1
condorQconstraint=$2
permanentUsers=$3
personalizeMethod=$4

if [ ! -f ${condorConfig} ] ; then
   echo "${condorConfig} does not exist"
   exitStatus=1
fi
if [ -z "${condorQconstraint}" ] ; then
   echo "missing condor queue constraint"
   exitStatus=1
fi
if [ ${personalizeMethod} != saml -a ${personalizeMethod} != copy ] ; then
   echo "personalizeMethod must be saml or copy"
   exitStatus=1
fi
if   [ ${personalizeMethod} = saml ] ; then
   gridshibHome=$5
   userProxyFile=$6
   if [ ! -d ${gridshibHome} ] ; then
      echo "${gridshibHome} is not a directory"
      exitStatus=1
   fi
elif [ ${personalizeMethod} = copy ] ; then
   certKeyDirectory=$5
   communityProxyFile=$6
   userProxyFile=$7
   if [ ! -d ${certKeyDirectory} ] ; then
      echo "${certKeyDirectory} is not a directory"
      exitStatus=1
   else
      if [ ! -f ${certKeyDirectory}/${communityProxyFile} ] ; then
         echo "${communityProxyFile} does not exist"
         exitStatus=1
      fi
   fi
fi

if [ ${exitStatus} -eq 0 ] ; then
   # Condor settings
   export PATH=/var/condor/Condor/X.X.X/bin:${PATH}

   export CONDOR_CONFIG=${condorConfig}
   condorUsers=$(condor_q -const "${condorQconstraint}" -format "%s\n" Owner)

   users=$(echo ${permanentUsers} ${condorUsers} | tr ' ' '\n' | sort -u)

   if   [ ${personalizeMethod} = saml ] ; then
      for user in ${users}; do
         echo '['`date +"%c"`']' "Proxy created for ${user}"
         userId=$(id -u ${user})
         proxyFile=$(echo ${userProxyFile} | sed -e "s/@@HUBUSERID/${userId}/g" -e "s/@@HUBUSERNAME/${user}/")
         ${scriptDir}/personalize-saml-proxy.sh ${user} ${gridshibHome} ${proxyFile}
         if [ $? -ne 0 ] ; then
            exitStatus=1
         fi
      done
   elif [ ${personalizeMethod} = copy ] ; then
      for user in ${users}; do
         echo '['`date +"%c"`']' "Proxy created for ${user}"
         userId=$(id -u ${user})
         proxyFile=$(echo ${userProxyFile} | sed -e "s/@@HUBUSERID/${userId}/g" -e "s/@@HUBUSERNAME/${user}/")
         ${scriptDir}/personalize-copy-proxy.sh ${user} ${certKeyDirectory} ${communityProxyFile} ${proxyFile}
         if [ $? -ne 0 ] ; then
            exitStatus=1
         fi
      done
   fi
fi

exit ${exitStatus}
