#!/usr/bin/env python3
#
# @package      hubzero-submit-monitors
# @file         cacheSimToolJobs.py
# @copyright    Copyright (c) 2004-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  cacheSimToolJobs.py
#
#  script which retrives and caches SimTool results
#
import sys
import os
import time
import logging
from errno import EINTR

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.CacheSimToolJobs     import CacheSimToolJobs

CACHEOUTPUTLOGLEVEL         = "INFO"
CACHEOUTPUTSYSLOGLOCAL      = "LOCAL3"
CACHEOUTPUTSYSLOGIDENTIFIER = "SUBMITJOBCACHESIMTOOLS"

DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'
INFOSDIRECTORY           = os.path.join(os.sep,"etc","submit")
INFOSCONFIGURATIONFILE   = 'infos.conf'

CACHEOUTPUTPIDFILE = os.path.join(os.sep,'var','run','submit','submit-jobcachesim2Ls.pid')

PREVIOUSSTATE = 'MEASURED'
NEXTSTATE     = 'CACHING'

if __name__ == '__main__':
   cacheOutputLogLevel         = os.getenv("CACHEOUTPUTLOGLEVEL",CACHEOUTPUTLOGLEVEL)
   cacheOutputSysLogLocal      = os.getenv("CACHEOUTPUTSYSLOGLOCAL",CACHEOUTPUTSYSLOGLOCAL)
   cacheOutputSysLogIdentifier = os.getenv("CACHEOUTPUTSYSLOGIDENTIFIER",CACHEOUTPUTSYSLOGIDENTIFIER)
   cacheOutputPidFile          = os.getenv("CACHEOUTPUTPIDFILE",CACHEOUTPUTPIDFILE)
   daemonsDirectory            = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile    = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)
   infosDirectory              = os.getenv("INFOSDIRECTORY",INFOSDIRECTORY)
   infosConfigurationFile      = os.getenv("INFOSCONFIGURATIONFILE",INFOSCONFIGURATIONFILE)

   applicationUtilities = ApplicationUtilities(CACHEOUTPUTLOGLEVEL,
                                               defaultSysLogLocal=CACHEOUTPUTSYSLOGLOCAL)
   applicationUtilities.openSysLogLogger(cacheOutputSysLogLocal,
                                         cacheOutputLogLevel,
                                         logIdentifier=cacheOutputSysLogIdentifier)
   applicationUtilities.daemonize()
   applicationUtilities.writePidFile(cacheOutputPidFile)

   cacheSimToolJobs = CacheSimToolJobs(daemonsDirectory,daemonsConfigurationFile,
                                       infosDirectory,infosConfigurationFile,
                                       PREVIOUSSTATE,NEXTSTATE)
   cacheSimToolJobs.process()


