#!/usr/bin/env python3
#
# @package      hubzero-submit-monitors
# @file         jobStageInput.py
# @copyright    Copyright (c) 2004-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  jobStageInput.py
#
#  script which submits staged jobs
#
import sys
import os
import time
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.StageJobs            import StageJobs

STAGEINPUTLOGLEVEL = "INFO"

DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'
INFOSDIRECTORY           = os.path.join(os.sep,"etc","submit")
INFOSCONFIGURATIONFILE   = 'infos.conf'

STAGEINPUTLOGLOCATION = os.path.join(os.sep,'var','log','submit','monitors')
STAGEINPUTLOGFILENAME = "jobStageInput.log"

STAGEINPUTPIDFILE = os.path.join(os.sep,'var','run','submit','submit-jobstageinput.pid')

PREVIOUSSTATE = 'PRESTAGED'
NEXTSTATE     = 'STAGING'

if __name__ == '__main__':
   stageInputLogLevel       = os.getenv("STAGEINPUTLOGLEVEL",STAGEINPUTLOGLEVEL)
   stageInputLogLocation    = os.getenv("STAGEINPUTLOGLOCATION",STAGEINPUTLOGLOCATION)
   stageInputLogFilename    = os.getenv("STAGEINPUTLOGFILENAME",STAGEINPUTLOGFILENAME)
   stageInputPidFile        = os.getenv("STAGEINPUTPIDFILE",STAGEINPUTPIDFILE)
   daemonsDirectory         = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)
   infosDirectory           = os.getenv("INFOSDIRECTORY",INFOSDIRECTORY)
   infosConfigurationFile   = os.getenv("INFOSCONFIGURATIONFILE",INFOSCONFIGURATIONFILE)

   applicationUtilities = ApplicationUtilities(STAGEINPUTLOGLEVEL)
   applicationUtilities.openFileLogger(stageInputLogLocation,stageInputLogFilename,
                                       stageInputLogLevel)
   applicationUtilities.daemonize()
   applicationUtilities.writePidFile(stageInputPidFile)

   stageJobs = StageJobs(daemonsDirectory,daemonsConfigurationFile,
                         infosDirectory,infosConfigurationFile,
                         PREVIOUSSTATE,NEXTSTATE)
   stageJobs.process()


