#!/usr/bin/env python3
#
# @package      hubzero-submit-monitors
# @file         monitorJobSiteSQL.py
# @copyright    Copyright (c) 2014-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2014-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  monitorJobSiteSQL.py
#
#  script which launches a single remote monitor and
#  feeds job status updates to the central job monitor.
#
import sys
import os
import time
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.MonitorJobSiteSQL    import MonitorJobSiteSQL as MonitorJobSite
from hubzero.submit.LogMessage           import getLogPIDMessage as getLogMessage

MONITORLOGLEVEL = "ERROR"

#MONITORROOT        = os.path.dirname(os.path.abspath(__file__))
MONITORLOGLOCATION = os.path.join(os.sep,'var','log','submit','monitors')
MONITORLOGFILENAME = "monitorJobSiteSQL.log"

MONITORDIRECTORY         = os.path.join(os.sep,"etc","submit")
MONITORCONFIGURATIONFILE = 'jobmonitor.conf'
DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'
INFOSDIRECTORY           = os.path.join(os.sep,"etc","submit")
INFOSCONFIGURATIONFILE   = 'infos.conf'

#BINDIRECTORY = os.path.join(MONITORROOT,'bin')
IDENTITYUSER = 'gridman'

ACTIVITYUPDATEINTERVAL = 15.
NOOPCHECKINTERVAL      = 60
NOOPINACTIVITYINTERVAL = 30*NOOPCHECKINTERVAL

if __name__ == '__main__':
   monitorLogLevel          = os.getenv("MONITORLOGLEVEL",MONITORLOGLEVEL)
   monitorDirectory         = os.getenv("MONITORDIRECTORY",MONITORDIRECTORY)
   monitorConfigurationFile = os.getenv("MONITORCONFIGURATIONFILE",MONITORCONFIGURATIONFILE)
   monitorLogLocation       = os.getenv("MONITORLOGLOCATION",MONITORLOGLOCATION)
   monitorLogFilename       = os.getenv("MONITORLOGFILENAME",MONITORLOGFILENAME)
   daemonsDirectory         = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)
   infosDirectory           = os.getenv("INFOSDIRECTORY",INFOSDIRECTORY)
   infosConfigurationFile   = os.getenv("INFOSCONFIGURATIONFILE",INFOSCONFIGURATIONFILE)
   activityUpdateInterval   = os.getenv("ACTIVITYUPDATEINTERVAL",ACTIVITYUPDATEINTERVAL)
   noOpCheckInterval        = os.getenv("NOOPCHECKINTERVAL",NOOPCHECKINTERVAL)
   noOpInactivityInterval   = os.getenv("NOOPINACTIVITYINTERVAL",NOOPINACTIVITYINTERVAL)

   applicationUtilities = ApplicationUtilities(MONITORLOGLEVEL)
   applicationUtilities.openFileLogger(monitorLogLocation,monitorLogFilename,
                                       monitorLogLevel)

   logger = logging.getLogger(__name__)

   exitStatus = 0
   if len(sys.argv) == 2:
      applicationUtilities.daemonize()

      __monitorJobSite__ = MonitorJobSite(monitorDirectory,monitorConfigurationFile,
                                          daemonsDirectory,daemonsConfigurationFile,
                                          infosDirectory,infosConfigurationFile,
                                          IDENTITYUSER,
                                          sys.argv[1],
                                          activityUpdateInterval,noOpCheckInterval,noOpInactivityInterval)
      exitStatus = __monitorJobSite__.monitorSite()
   else:
      logger.log(logging.ERROR,getLogMessage("job site name not specified"))
      exitStatus = 1

   sys.exit(exitStatus)


