#!/usr/bin/env python3
#
# @package      hubzero-submit-monitors
# @file         monitorTunnel.py
# @copyright    Copyright (c) 2004-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2004-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
# ----------------------------------------------------------------------
#  monitorTunnel.py
#
#  script which monitors ssh tunnels for use with distributor and related processes.
#
import sys
import os
import time
import logging

from hubzero.submit.ApplicationUtilities import ApplicationUtilities as ApplicationUtilities
from hubzero.submit.MonitorTunnel        import MonitorTunnel

MONITORLOGLEVEL = "INFO"

MONITORROOT        = os.path.dirname(os.path.abspath(__file__))
MONITORLOGLOCATION = os.path.join(os.sep,'var','log','submit','monitors')
MONITORLOGFILENAME = "monitorTunnel.log"

MONITORPIDFILE = os.path.join(os.sep,'var','run','submit','submit-tunnel.pid')

DAEMONSDIRECTORY         = os.path.join(os.sep,"etc","submit")
DAEMONSCONFIGURATIONFILE = 'daemons.conf'
INFOSDIRECTORY           = os.path.join(os.sep,"etc","submit")
INFOSCONFIGURATIONFILE   = 'infos.conf'

ACTIVITYUPDATEINTERVAL = 15.*60.

if __name__ == '__main__':
   monitorLogLevel          = os.getenv("MONITORLOGLEVEL",MONITORLOGLEVEL)
   monitorLogLocation       = os.getenv("MONITORLOGLOCATION",MONITORLOGLOCATION)
   monitorLogFilename       = os.getenv("MONITORLOGFILENAME",MONITORLOGFILENAME)
   monitorPidFile           = os.getenv("MONITORPIDFILE",MONITORPIDFILE)
   daemonsDirectory         = os.getenv("DAEMONSDIRECTORY",DAEMONSDIRECTORY)
   daemonsConfigurationFile = os.getenv("DAEMONSCONFIGURATIONFILE",DAEMONSCONFIGURATIONFILE)
   infosDirectory           = os.getenv("INFOSDIRECTORY",INFOSDIRECTORY)
   infosConfigurationFile   = os.getenv("INFOSCONFIGURATIONFILE",INFOSCONFIGURATIONFILE)
   activityUpdateInterval   = os.getenv("ACTIVITYUPDATEINTERVAL",ACTIVITYUPDATEINTERVAL)

   applicationUtilities = ApplicationUtilities(MONITORLOGLEVEL)
   applicationUtilities.openFileLogger(monitorLogLocation,monitorLogFilename,
                                       monitorLogLevel)
   applicationUtilities.daemonize()
   applicationUtilities.writePidFile(monitorPidFile)

   monitorTunnel = MonitorTunnel(MONITORROOT,
                                 daemonsDirectory,daemonsConfigurationFile,
                                 infosDirectory,infosConfigurationFile,
                                 activityUpdateInterval)
   monitorTunnel.monitor()


