#!/bin/sh
#
# @package      hubzero-submit-monitors
# @file         genuserid.sh
# @copyright    Copyright (c) 2015-2020 The Regents of the University of California.
# @license      http://opensource.org/licenses/MIT MIT
#
# Copyright (c) 2015-2020 The Regents of the University of California.
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
#
# HUBzero is a registered trademark of The Regents of the University of California.
#
scriptPath=$(readlink -f $0)
scriptDir=$(dirname ${scriptPath})

if [ $# -ne 3 ] ; then
   echo "usage: $0 user communityPrivateKeyFile userPrivateKeyFile"
   exit 64
fi

exitStatus=0

user=$1
communityPrivateKeyFile=$2
userPrivateKeyFile=$3

if [ ! -f ${communityPrivateKeyFile} ] ; then
   echo "${communityPrivateKeyFile} does not exist"
   exitStatus=1
fi

if [ ${exitStatus} -eq 0 ] ; then
   export COMMUNITYSECRET="$(cat ${communityPrivateKeyFile})"
   sudo -u ${user} ${scriptDir}/writecommunitysecret.sh /tmp/${userPrivateKeyFile}
   exitStatus=$?
fi

exit ${exitStatus}
